/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.ForeignKeyDeleteAction;
import com.sleepycat.db.ForeignKeyNullifier;
import com.sleepycat.db.ForeignMultiKeyNullifier;
import com.sleepycat.db.SecondaryKeyCreator;
import com.sleepycat.db.SecondaryMultiKeyCreator;
import com.sleepycat.db.internal.Db;
import com.sleepycat.db.internal.DbEnv;
import com.sleepycat.db.internal.DbTxn;
import java.io.FileNotFoundException;

public class SecondaryConfig
extends DatabaseConfig
implements Cloneable {
    public static final SecondaryConfig DEFAULT = new SecondaryConfig();
    private boolean allowPopulate;
    private boolean immutableSecondaryKey;
    private Db foreign;
    private ForeignKeyDeleteAction fkDelAction;
    private ForeignKeyNullifier keyNullifier;
    private ForeignMultiKeyNullifier multiKeyNullifier;
    private SecondaryKeyCreator keyCreator;
    private SecondaryMultiKeyCreator multiKeyCreator;

    static SecondaryConfig checkNull(SecondaryConfig config) {
        return config == null ? DEFAULT : config;
    }

    public SecondaryConfig() {
    }

    public void setAllowPopulate(boolean allowPopulate) {
        this.allowPopulate = allowPopulate;
    }

    public boolean getAllowPopulate() {
        return this.allowPopulate;
    }

    public void setImmutableSecondaryKey(boolean immutableSecondaryKey) {
        this.immutableSecondaryKey = immutableSecondaryKey;
    }

    public boolean getImmutableSecondaryKey() {
        return this.immutableSecondaryKey;
    }

    public void setKeyCreator(SecondaryKeyCreator keyCreator) {
        this.keyCreator = keyCreator;
    }

    public SecondaryKeyCreator getKeyCreator() {
        return this.keyCreator;
    }

    public void setMultiKeyCreator(SecondaryMultiKeyCreator multiKeyCreator) {
        this.multiKeyCreator = multiKeyCreator;
    }

    public SecondaryMultiKeyCreator getMultiKeyCreator() {
        return this.multiKeyCreator;
    }

    public void setForeignKeyDatabase(Database foreignDb) {
        this.foreign = foreignDb.db;
    }

    public Db getForeignKeyDatabase() {
        return this.foreign;
    }

    public void setForeignKeyDeleteAction(ForeignKeyDeleteAction action) {
        this.fkDelAction = action;
    }

    public ForeignKeyDeleteAction getForeignKeyDeleteAction() {
        return this.fkDelAction;
    }

    public void setForeignKeyNullifier(ForeignKeyNullifier keyNullifier) {
        this.keyNullifier = keyNullifier;
    }

    public ForeignKeyNullifier getForeignKeyNullifier() {
        return this.keyNullifier;
    }

    public void setForeignMultiKeyNullifier(ForeignMultiKeyNullifier multiKeyNullifier) {
        this.multiKeyNullifier = multiKeyNullifier;
    }

    public ForeignMultiKeyNullifier getForeignMultiKeyNullifier() {
        return this.multiKeyNullifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Db openSecondaryDatabase(DbEnv dbenv, DbTxn txn, String fileName, String databaseName, Db primary) throws DatabaseException, FileNotFoundException {
        int associateFlags = 0;
        int foreignFlags = 0;
        associateFlags |= this.allowPopulate ? 1 : 0;
        if (this.getTransactional() && txn == null) {
            associateFlags |= 0x100;
        }
        if (this.immutableSecondaryKey) {
            associateFlags |= 2;
        }
        Db db = super.openDatabase(dbenv, txn, fileName, databaseName);
        boolean succeeded = false;
        try {
            db.set_secmultikey_create(this.multiKeyCreator);
            primary.associate(txn, db, this.keyCreator, associateFlags);
            if (this.foreign != null) {
                db.set_foreignmultikey_nullifier(this.multiKeyNullifier);
                this.foreign.associate_foreign(db, this.keyNullifier, foreignFlags | this.fkDelAction.getId());
            }
            succeeded = true;
            Db db2 = db;
            return db2;
        }
        finally {
            if (!succeeded) {
                try {
                    db.close(0);
                }
                catch (Throwable t) {}
            }
        }
    }

    SecondaryConfig(Db db) throws DatabaseException {
        super(db);
        this.allowPopulate = false;
        this.immutableSecondaryKey = false;
        this.keyCreator = db.get_seckey_create();
        this.multiKeyCreator = db.get_secmultikey_create();
    }
}

