/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.LogSequenceNumber;
import com.sleepycat.db.internal.DbEnv;

public final class ReplicationStatus {
    static final ReplicationStatus SUCCESS = new ReplicationStatus("SUCCESS", 0);
    private int errCode;
    private DatabaseEntry cdata;
    private int envid;
    private LogSequenceNumber lsn;
    private String statusName;
    private static final ReplicationStatus IGNORE = new ReplicationStatus("IGNORE", -30982);

    private ReplicationStatus(String statusName, int errCode, DatabaseEntry cdata, int envid, LogSequenceNumber lsn) {
        this.statusName = statusName;
        this.errCode = errCode;
        this.cdata = cdata;
        this.envid = envid;
        this.lsn = lsn;
    }

    private ReplicationStatus(String statusName, int errCode) {
        this(statusName, errCode, null, 0, null);
    }

    public boolean isSuccess() {
        return this.errCode == 0;
    }

    public boolean isIgnore() {
        return this.errCode == -30982;
    }

    public boolean isPermanent() {
        return this.errCode == -30981;
    }

    public boolean isNewSite() {
        return this.errCode == -30977;
    }

    public boolean isNotPermanent() {
        return this.errCode == -30976;
    }

    public DatabaseEntry getCData() {
        return this.cdata;
    }

    public int getEnvID() {
        return this.envid;
    }

    public LogSequenceNumber getLSN() {
        return this.lsn;
    }

    public String toString() {
        return "ReplicationStatus." + this.statusName;
    }

    static ReplicationStatus getStatus(int errCode, DatabaseEntry cdata, int envid, LogSequenceNumber lsn) {
        switch (errCode) {
            case 0: {
                return SUCCESS;
            }
            case -30982: {
                return IGNORE;
            }
            case -30981: {
                return new ReplicationStatus("ISPERM", errCode, cdata, envid, lsn);
            }
            case -30977: {
                return new ReplicationStatus("NEWSITE", errCode, cdata, envid, lsn);
            }
            case -30976: {
                return new ReplicationStatus("NOTPERM", errCode, cdata, envid, lsn);
            }
        }
        throw new IllegalArgumentException("Unknown error code: " + DbEnv.strerror(errCode));
    }
}

