/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.MultipleEntry;
import com.sleepycat.db.internal.DbUtil;
import java.nio.ByteBuffer;

public class MultipleRecnoNIODataEntry
extends MultipleEntry {
    public MultipleRecnoNIODataEntry() {
        super((ByteBuffer)null);
    }

    public MultipleRecnoNIODataEntry(ByteBuffer data) {
        super(data);
    }

    int getMultiFlag() {
        this.pos = 0;
        return 16384;
    }

    public boolean next(DatabaseEntry recno, DatabaseEntry data) {
        if (this.pos == 0) {
            this.pos = this.ulen - 4;
        }
        if (this.data_nio.capacity() < 12) {
            return false;
        }
        byte[] intarr = new byte[12];
        int saveoffset = this.data_nio.position();
        this.data_nio.position(this.pos - 8);
        this.data_nio.get(intarr, 0, 12);
        this.data_nio.position(saveoffset);
        int keyoff = DbUtil.array2int(intarr, 8);
        if (keyoff < 0) {
            return false;
        }
        int dataoff = DbUtil.array2int(intarr, 4);
        int datasz = DbUtil.array2int(intarr, 0);
        this.pos -= 12;
        recno.setDataNIO(this.data_nio);
        recno.setOffset(keyoff);
        recno.setSize(4);
        data.setDataNIO(this.data_nio);
        data.setOffset(dataoff);
        data.setSize(datasz);
        return true;
    }
}

