/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.BtreeCompressor;
import com.sleepycat.db.BtreePrefixCalculator;
import com.sleepycat.db.CacheFilePriority;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.DatabaseType;
import com.sleepycat.db.ErrorHandler;
import com.sleepycat.db.FeedbackHandler;
import com.sleepycat.db.Hasher;
import com.sleepycat.db.MessageHandler;
import com.sleepycat.db.MultipleDataEntry;
import com.sleepycat.db.PanicHandler;
import com.sleepycat.db.PartitionHandler;
import com.sleepycat.db.RecordNumberAppender;
import com.sleepycat.db.internal.Db;
import com.sleepycat.db.internal.DbEnv;
import com.sleepycat.db.internal.DbTxn;
import com.sleepycat.db.internal.DbUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.Comparator;

public class DatabaseConfig
implements Cloneable {
    public static final DatabaseConfig DEFAULT = new DatabaseConfig();
    private DatabaseType type = DatabaseType.UNKNOWN;
    private int mode = 420;
    private int btMinKey = 0;
    private int byteOrder = 0;
    private long cacheSize = 0L;
    private File createDir = null;
    private int cacheCount = 0;
    private OutputStream errorStream = null;
    private String errorPrefix = null;
    private int hashFillFactor = 0;
    private int hashNumElements = 0;
    private OutputStream messageStream = null;
    private int pageSize = 0;
    private File[] partitionDirs = null;
    private DatabaseEntry partitionKeys = null;
    private int partitionParts = 0;
    private String password = null;
    private CacheFilePriority priority = null;
    private int queueExtentSize = 0;
    private int recordDelimiter = 0;
    private int recordLength = 0;
    private int recordPad = -1;
    private File recordSource = null;
    private boolean allowCreate = false;
    private boolean btreeRecordNumbers = false;
    private boolean checksum = false;
    private boolean readUncommitted = false;
    private boolean encrypted = false;
    private boolean exclusiveCreate = false;
    private boolean multiversion = false;
    private boolean noMMap = false;
    private boolean queueInOrder = false;
    private boolean readOnly = false;
    private boolean renumbering = false;
    private boolean reverseSplitOff = false;
    private boolean sortedDuplicates = false;
    private boolean snapshot = false;
    private boolean unsortedDuplicates = false;
    private boolean transactional = false;
    private boolean transactionNotDurable = false;
    private boolean truncate = false;
    private Comparator btreeComparator = null;
    private BtreeCompressor btreeCompressor = null;
    private BtreePrefixCalculator btreePrefixCalculator = null;
    private Comparator duplicateComparator = null;
    private FeedbackHandler feedbackHandler = null;
    private ErrorHandler errorHandler = null;
    private MessageHandler messageHandler = null;
    private PartitionHandler partitionHandler = null;
    private Comparator hashComparator = null;
    private Hasher hasher = null;
    private RecordNumberAppender recnoAppender = null;
    private PanicHandler panicHandler = null;

    static DatabaseConfig checkNull(DatabaseConfig config) {
        return config == null ? DEFAULT : config;
    }

    public DatabaseConfig() {
    }

    public DatabaseConfig cloneConfig() {
        try {
            return (DatabaseConfig)super.clone();
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean getAllowCreate() {
        return this.allowCreate;
    }

    public void setBtreeComparator(Comparator btreeComparator) {
        this.btreeComparator = btreeComparator;
    }

    public Comparator getBtreeComparator() {
        return this.btreeComparator;
    }

    public void setBtreeMinKey(int btMinKey) {
        this.btMinKey = btMinKey;
    }

    public int getBtreeMinKey() {
        return this.btMinKey;
    }

    public void setByteOrder(int byteOrder) {
        this.byteOrder = byteOrder;
    }

    public int getByteOrder() {
        return this.byteOrder;
    }

    public boolean getByteSwapped() {
        return this.byteOrder != 0 && this.byteOrder != DbUtil.default_lorder();
    }

    public void setBtreeCompressor(BtreeCompressor btreeCompressor) {
        this.btreeCompressor = btreeCompressor;
    }

    public BtreeCompressor getBtreeCompressor() {
        return this.btreeCompressor;
    }

    public void setBtreePrefixCalculator(BtreePrefixCalculator btreePrefixCalculator) {
        this.btreePrefixCalculator = btreePrefixCalculator;
    }

    public BtreePrefixCalculator getBtreePrefixCalculator() {
        return this.btreePrefixCalculator;
    }

    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public void setCreateDir(File createDir) {
        this.createDir = createDir;
    }

    public File getCreateDir() {
        return this.createDir;
    }

    public void setCacheCount(int cacheCount) {
        this.cacheCount = cacheCount;
    }

    public int getCacheCount() {
        return this.cacheCount;
    }

    public void setChecksum(boolean checksum) {
        this.checksum = checksum;
    }

    public boolean getChecksum() {
        return this.checksum;
    }

    public void setReadUncommitted(boolean readUncommitted) {
        this.readUncommitted = readUncommitted;
    }

    public boolean getReadUncommitted() {
        return this.readUncommitted;
    }

    public void setDirtyRead(boolean dirtyRead) {
        this.setReadUncommitted(dirtyRead);
    }

    public boolean getDirtyRead() {
        return this.getReadUncommitted();
    }

    public void setDuplicateComparator(Comparator duplicateComparator) {
        this.duplicateComparator = duplicateComparator;
    }

    public Comparator getDuplicateComparator() {
        return this.duplicateComparator;
    }

    public void setEncrypted(String password) {
        this.password = password;
    }

    public boolean getEncrypted() {
        return this.password != null;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorPrefix(String errorPrefix) {
        this.errorPrefix = errorPrefix;
    }

    public String getErrorPrefix() {
        return this.errorPrefix;
    }

    public void setErrorStream(OutputStream errorStream) {
        this.errorStream = errorStream;
    }

    public OutputStream getErrorStream() {
        return this.errorStream;
    }

    public void setExclusiveCreate(boolean exclusiveCreate) {
        this.exclusiveCreate = exclusiveCreate;
    }

    public boolean getExclusiveCreate() {
        return this.exclusiveCreate;
    }

    public void setFeedbackHandler(FeedbackHandler feedbackHandler) {
        this.feedbackHandler = feedbackHandler;
    }

    public FeedbackHandler getFeedbackHandler() {
        return this.feedbackHandler;
    }

    public void setHashFillFactor(int hashFillFactor) {
        this.hashFillFactor = hashFillFactor;
    }

    public int getHashFillFactor() {
        return this.hashFillFactor;
    }

    public void setHashComparator(Comparator hashComparator) {
        this.hashComparator = hashComparator;
    }

    public Comparator getHashComparator() {
        return this.hashComparator;
    }

    public void setHasher(Hasher hasher) {
        this.hasher = hasher;
    }

    public Hasher getHasher() {
        return this.hasher;
    }

    public void setHashNumElements(int hashNumElements) {
        this.hashNumElements = hashNumElements;
    }

    public int getHashNumElements() {
        return this.hashNumElements;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageStream(OutputStream messageStream) {
        this.messageStream = messageStream;
    }

    public OutputStream getMessageStream() {
        return this.messageStream;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public long getMode() {
        return this.mode;
    }

    public void setMultiversion(boolean multiversion) {
        this.multiversion = multiversion;
    }

    public boolean getMultiversion() {
        return this.multiversion;
    }

    public void setNoMMap(boolean noMMap) {
        this.noMMap = noMMap;
    }

    public boolean getNoMMap() {
        return this.noMMap;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPanicHandler(PanicHandler panicHandler) {
        this.panicHandler = panicHandler;
    }

    public PanicHandler getPanicHandler() {
        return this.panicHandler;
    }

    public void setPartitionByCallback(int parts, PartitionHandler partitionHandler) {
        this.partitionParts = parts;
        this.partitionHandler = partitionHandler;
    }

    public void setPartitionByRange(int parts, MultipleDataEntry keys) {
        this.partitionParts = parts;
        this.partitionKeys = keys;
    }

    public PartitionHandler getPartitionHandler() {
        return this.partitionHandler;
    }

    public int getPartitionParts() {
        return this.partitionParts;
    }

    public DatabaseEntry getPartitionKeys() {
        return this.partitionKeys;
    }

    public void setPartitionDirs(File[] dirs) {
        this.partitionDirs = dirs;
    }

    public File[] getPartitionDirs() {
        return this.partitionDirs;
    }

    public void setPriority(CacheFilePriority priority) {
        this.priority = priority;
    }

    public CacheFilePriority getPriority() {
        return this.priority;
    }

    public void setQueueExtentSize(int queueExtentSize) {
        this.queueExtentSize = queueExtentSize;
    }

    public int getQueueExtentSize() {
        return this.queueExtentSize;
    }

    public void setQueueInOrder(boolean queueInOrder) {
        this.queueInOrder = queueInOrder;
    }

    public boolean getQueueInOrder() {
        return this.queueInOrder;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setRecordNumberAppender(RecordNumberAppender recnoAppender) {
        this.recnoAppender = recnoAppender;
    }

    public RecordNumberAppender getRecordNumberAppender() {
        return this.recnoAppender;
    }

    public void setRecordDelimiter(int recordDelimiter) {
        this.recordDelimiter = recordDelimiter;
    }

    public int getRecordDelimiter() {
        return this.recordDelimiter;
    }

    public void setRecordLength(int recordLength) {
        this.recordLength = recordLength;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public void setBtreeRecordNumbers(boolean btreeRecordNumbers) {
        this.btreeRecordNumbers = btreeRecordNumbers;
    }

    public boolean getBtreeRecordNumbers() {
        return this.btreeRecordNumbers;
    }

    public void setRecordPad(int recordPad) {
        this.recordPad = recordPad;
    }

    public int getRecordPad() {
        return this.recordPad;
    }

    public void setRecordSource(File recordSource) {
        this.recordSource = recordSource;
    }

    public File getRecordSource() {
        return this.recordSource;
    }

    public void setRenumbering(boolean renumbering) {
        this.renumbering = renumbering;
    }

    public boolean getRenumbering() {
        return this.renumbering;
    }

    public void setReverseSplitOff(boolean reverseSplitOff) {
        this.reverseSplitOff = reverseSplitOff;
    }

    public boolean getReverseSplitOff() {
        return this.reverseSplitOff;
    }

    public void setSortedDuplicates(boolean sortedDuplicates) {
        this.sortedDuplicates = sortedDuplicates;
    }

    public boolean getSortedDuplicates() {
        return this.sortedDuplicates;
    }

    public void setUnsortedDuplicates(boolean unsortedDuplicates) {
        this.unsortedDuplicates = unsortedDuplicates;
    }

    public boolean getUnsortedDuplicates() {
        return this.unsortedDuplicates;
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    public boolean getSnapshot() {
        return this.snapshot;
    }

    public boolean getTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public void setTransactionNotDurable(boolean transactionNotDurable) {
        this.transactionNotDurable = transactionNotDurable;
    }

    public boolean getTransactionNotDurable() {
        return this.transactionNotDurable;
    }

    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }

    public boolean getTruncate() {
        return this.truncate;
    }

    public void setType(DatabaseType type) {
        this.type = type;
    }

    public DatabaseType getType() {
        return this.type;
    }

    Db createDatabase(DbEnv dbenv) throws DatabaseException {
        return new Db(dbenv, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Db openDatabase(DbEnv dbenv, DbTxn txn, String fileName, String databaseName) throws DatabaseException, FileNotFoundException {
        Db db = this.createDatabase(dbenv);
        boolean threaded = dbenv == null || (dbenv.get_open_flags() & 0x10) != 0;
        int openFlags = 0;
        openFlags |= this.allowCreate ? 1 : 0;
        openFlags |= this.readUncommitted ? 512 : 0;
        openFlags |= this.exclusiveCreate ? 64 : 0;
        openFlags |= this.multiversion ? 4 : 0;
        openFlags |= this.noMMap ? 8 : 0;
        openFlags |= this.readOnly ? 1024 : 0;
        openFlags |= threaded ? 16 : 0;
        openFlags |= this.truncate ? 16384 : 0;
        if (this.transactional && txn == null) {
            openFlags |= 0x100;
        }
        boolean succeeded = false;
        try {
            this.configureDatabase(db, DEFAULT);
            db.open(txn, fileName, databaseName, this.type.getId(), openFlags, this.mode);
            succeeded = true;
            Db db2 = db;
            return db2;
        }
        finally {
            if (!succeeded) {
                try {
                    db.close(0);
                }
                catch (Throwable t) {}
            }
        }
    }

    void configureDatabase(Db db, DatabaseConfig oldConfig) throws DatabaseException {
        int dbFlags = 0;
        dbFlags |= this.checksum ? 8 : 0;
        dbFlags |= this.btreeRecordNumbers ? 64 : 0;
        dbFlags |= this.queueInOrder ? 32 : 0;
        dbFlags |= this.renumbering ? 128 : 0;
        dbFlags |= this.reverseSplitOff ? 256 : 0;
        dbFlags |= this.sortedDuplicates ? 4 : 0;
        dbFlags |= this.snapshot ? 512 : 0;
        dbFlags |= this.unsortedDuplicates ? 16 : 0;
        dbFlags |= this.transactionNotDurable ? 2 : 0;
        if (!db.getPrivateDbEnv()) {
            dbFlags |= this.password != null ? 1 : 0;
        }
        if (dbFlags != 0) {
            db.set_flags(dbFlags);
        }
        if (this.btMinKey != oldConfig.btMinKey) {
            db.set_bt_minkey(this.btMinKey);
        }
        if (this.byteOrder != oldConfig.byteOrder) {
            db.set_lorder(this.byteOrder);
        }
        if ((this.cacheSize != oldConfig.cacheSize || this.cacheCount != oldConfig.cacheCount) && db.getPrivateDbEnv()) {
            db.set_cachesize(this.cacheSize, this.cacheCount);
        }
        if (this.createDir != oldConfig.createDir && this.createDir != null && !this.createDir.equals(oldConfig.createDir)) {
            db.set_create_dir(this.createDir.toString());
        }
        if (this.errorStream != oldConfig.errorStream) {
            db.set_error_stream(this.errorStream);
        }
        if (this.errorPrefix != oldConfig.errorPrefix) {
            db.set_errpfx(this.errorPrefix);
        }
        if (this.hashFillFactor != oldConfig.hashFillFactor) {
            db.set_h_ffactor(this.hashFillFactor);
        }
        if (this.hashNumElements != oldConfig.hashNumElements) {
            db.set_h_nelem(this.hashNumElements);
        }
        if (this.messageStream != oldConfig.messageStream) {
            db.set_message_stream(this.messageStream);
        }
        if (this.pageSize != oldConfig.pageSize) {
            db.set_pagesize(this.pageSize);
        }
        if (this.partitionDirs != null && this.partitionDirs != oldConfig.partitionDirs) {
            String[] partitionDirArray = new String[this.partitionDirs.length];
            for (int i = 0; i < partitionDirArray.length; ++i) {
                partitionDirArray[i] = this.partitionDirs[i].toString();
            }
            db.set_partition_dirs(partitionDirArray);
        }
        if (this.password != oldConfig.password && db.getPrivateDbEnv()) {
            db.set_encrypt(this.password, 1);
        }
        if (this.priority != oldConfig.priority) {
            db.set_priority(this.priority.getFlag());
        }
        if (this.queueExtentSize != oldConfig.queueExtentSize) {
            db.set_q_extentsize(this.queueExtentSize);
        }
        if (this.recordDelimiter != oldConfig.recordDelimiter) {
            db.set_re_delim(this.recordDelimiter);
        }
        if (this.recordLength != oldConfig.recordLength) {
            db.set_re_len(this.recordLength);
        }
        if (this.recordPad != oldConfig.recordPad) {
            db.set_re_pad(this.recordPad);
        }
        if (this.recordSource != oldConfig.recordSource) {
            db.set_re_source(this.recordSource == null ? null : this.recordSource.toString());
        }
        if (this.btreeComparator != oldConfig.btreeComparator) {
            db.set_bt_compare(this.btreeComparator);
        }
        if (this.btreeCompressor != oldConfig.btreeCompressor) {
            db.set_bt_compress(this.btreeCompressor, this.btreeCompressor);
        }
        if (this.btreePrefixCalculator != oldConfig.btreePrefixCalculator) {
            db.set_bt_prefix(this.btreePrefixCalculator);
        }
        if (this.duplicateComparator != oldConfig.duplicateComparator) {
            db.set_dup_compare(this.duplicateComparator);
        }
        if (this.feedbackHandler != oldConfig.feedbackHandler) {
            db.set_feedback(this.feedbackHandler);
        }
        if (this.errorHandler != oldConfig.errorHandler) {
            db.set_errcall(this.errorHandler);
        }
        if (this.hashComparator != oldConfig.hashComparator) {
            db.set_h_compare(this.hashComparator);
        }
        if (this.hasher != oldConfig.hasher) {
            db.set_h_hash(this.hasher);
        }
        if (this.messageHandler != oldConfig.messageHandler) {
            db.set_msgcall(this.messageHandler);
        }
        if (this.partitionHandler != oldConfig.partitionHandler || this.partitionKeys != oldConfig.partitionKeys || this.partitionParts != oldConfig.partitionParts) {
            db.set_partition(this.partitionParts, this.partitionKeys, this.partitionHandler);
        }
        if (this.recnoAppender != oldConfig.recnoAppender) {
            db.set_append_recno(this.recnoAppender);
        }
        if (this.panicHandler != oldConfig.panicHandler) {
            db.set_paniccall(this.panicHandler);
        }
    }

    DatabaseConfig(Db db) throws DatabaseException {
        this.type = DatabaseType.fromInt(db.get_type());
        int openFlags = db.get_open_flags();
        this.allowCreate = (openFlags & 1) != 0;
        this.readUncommitted = (openFlags & 0x200) != 0;
        this.exclusiveCreate = (openFlags & 0x40) != 0;
        this.multiversion = (openFlags & 4) != 0;
        this.noMMap = (openFlags & 8) != 0;
        this.readOnly = (openFlags & 0x400) != 0;
        this.truncate = (openFlags & 0x4000) != 0;
        int dbFlags = db.get_flags();
        this.checksum = (dbFlags & 8) != 0;
        this.btreeRecordNumbers = (dbFlags & 0x40) != 0;
        this.queueInOrder = (dbFlags & 0x20) != 0;
        this.renumbering = (dbFlags & 0x80) != 0;
        this.reverseSplitOff = (dbFlags & 0x100) != 0;
        this.sortedDuplicates = (dbFlags & 4) != 0;
        this.snapshot = (dbFlags & 0x200) != 0;
        this.unsortedDuplicates = (dbFlags & 0x10) != 0;
        boolean bl = this.transactionNotDurable = (dbFlags & 2) != 0;
        if (this.type == DatabaseType.BTREE) {
            this.btMinKey = db.get_bt_minkey();
        }
        this.byteOrder = db.get_lorder();
        this.cacheSize = db.get_env().get_cachesize();
        this.cacheCount = db.get_env().get_cachesize_ncache();
        this.errorStream = db.get_error_stream();
        this.errorPrefix = db.get_errpfx();
        if (this.type == DatabaseType.HASH) {
            this.hashFillFactor = db.get_h_ffactor();
            this.hashNumElements = db.get_h_nelem();
        }
        this.messageStream = db.get_message_stream();
        this.password = (dbFlags & 1) != 0 ? "" : null;
        this.priority = CacheFilePriority.fromFlag(db.get_priority());
        if (this.type == DatabaseType.QUEUE) {
            this.queueExtentSize = db.get_q_extentsize();
        }
        if (this.type == DatabaseType.QUEUE || this.type == DatabaseType.RECNO) {
            this.recordLength = db.get_re_len();
            this.recordPad = db.get_re_pad();
        }
        if (this.type == DatabaseType.RECNO) {
            this.recordDelimiter = db.get_re_delim();
            this.recordSource = db.get_re_source() == null ? null : new File(db.get_re_source());
        }
        this.transactional = db.get_transactional();
        this.createDir = db.get_create_dir() == null ? null : new File(db.get_create_dir());
        String[] partitionDirArray = db.get_partition_dirs();
        if (partitionDirArray == null) {
            partitionDirArray = new String[]{};
        }
        this.partitionDirs = new File[partitionDirArray.length];
        for (int i = 0; i < partitionDirArray.length; ++i) {
            this.partitionDirs[i] = new File(partitionDirArray[i]);
        }
        this.btreeComparator = db.get_bt_compare();
        this.btreeCompressor = db.get_bt_compress();
        this.btreePrefixCalculator = db.get_bt_prefix();
        this.duplicateComparator = db.get_dup_compare();
        this.feedbackHandler = db.get_feedback();
        this.errorHandler = db.get_errcall();
        this.hashComparator = db.get_h_compare();
        this.hasher = db.get_h_hash();
        this.messageHandler = db.get_msgcall();
        this.partitionParts = db.get_partition_parts();
        this.partitionKeys = db.get_partition_keys();
        this.partitionHandler = db.get_partition_callback();
        this.recnoAppender = db.get_append_recno();
        this.panicHandler = db.get_paniccall();
    }
}

