/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.serial;

import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.ForeignKeyNullifier;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.SecondaryKeyCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SerialSerialKeyCreator<PK, D, SK>
implements SecondaryKeyCreator,
ForeignKeyNullifier {
    protected SerialBinding<PK> primaryKeyBinding;
    protected SerialBinding<D> dataBinding;
    protected SerialBinding<SK> indexKeyBinding;

    public SerialSerialKeyCreator(ClassCatalog classCatalog, Class<PK> primaryKeyClass, Class<D> dataClass, Class<SK> indexKeyClass) {
        this(new SerialBinding<PK>(classCatalog, primaryKeyClass), new SerialBinding<D>(classCatalog, dataClass), new SerialBinding<SK>(classCatalog, indexKeyClass));
    }

    public SerialSerialKeyCreator(SerialBinding<PK> primaryKeyBinding, SerialBinding<D> dataBinding, SerialBinding<SK> indexKeyBinding) {
        this.primaryKeyBinding = primaryKeyBinding;
        this.dataBinding = dataBinding;
        this.indexKeyBinding = indexKeyBinding;
    }

    @Override
    public boolean createSecondaryKey(SecondaryDatabase db, DatabaseEntry primaryKeyEntry, DatabaseEntry dataEntry, DatabaseEntry indexKeyEntry) {
        D dataInput;
        PK primaryKeyInput = this.primaryKeyBinding.entryToObject(primaryKeyEntry);
        SK indexKey = this.createSecondaryKey(primaryKeyInput, dataInput = this.dataBinding.entryToObject(dataEntry));
        if (indexKey != null) {
            this.indexKeyBinding.objectToEntry(indexKey, indexKeyEntry);
            return true;
        }
        return false;
    }

    @Override
    public boolean nullifyForeignKey(SecondaryDatabase db, DatabaseEntry dataEntry) {
        D data = this.dataBinding.entryToObject(dataEntry);
        if ((data = this.nullifyForeignKey(data)) != null) {
            this.dataBinding.objectToEntry(data, dataEntry);
            return true;
        }
        return false;
    }

    public abstract SK createSecondaryKey(PK var1, D var2);

    public D nullifyForeignKey(D data) {
        return null;
    }
}

