/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.DatabaseEntry;

public class RecordNumberBinding
implements EntryBinding {
    public Long entryToObject(DatabaseEntry entry) {
        return RecordNumberBinding.entryToRecordNumber(entry);
    }

    public void objectToEntry(Object object, DatabaseEntry entry) {
        RecordNumberBinding.recordNumberToEntry(((Number)object).longValue(), entry);
    }

    public static long entryToRecordNumber(DatabaseEntry entry) {
        return (long)DbCompat.getRecordNumber(entry) & 0xFFFFFFFFL;
    }

    public static void recordNumberToEntry(long recordNumber, DatabaseEntry entry) {
        entry.setData(new byte[4], 0, 4);
        DbCompat.setRecordNumber(entry, (int)recordNumber);
    }
}

